/**************************************************************************/
/*                                                                        */
/*  This file is part of Frama-C.                                         */
/*                                                                        */
/*  Copyright (C) 2013-2014                                               */
/*    CEA (Commissariat à l'énergie atomique et aux énergies              */
/*         alternatives)                                                  */
/*                                                                        */
/*  You may redistribute it and/or modify it under the terms of the GNU   */
/*  Lesser General Public License as published by the Free Software       */
/*  Foundation, version 2.1.                                              */
/*                                                                        */
/*  It is distributed in the hope that it will be useful, but WITHOUT     */
/*  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY    */
/*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General      */
/*  Public License for more details.                                      */
/*                                                                        */
/*  See the GNU Lesser General Public License version 2.1 for more        */
/*  details (enclosed in the file LICENSE).                               */
/*                                                                        */
/**************************************************************************/

#ifndef COVLABELS_OUTPUT
#define COVLABELS_OUTPUT a.covlabels
#endif

#ifndef COVLABELS_TESTDRIVER
#define COVLABELS_TESTDRIVER unknown
#endif

#define str(x) # x
#define xstr(x) str(x)


/******************************************************************************/

#undef pc_label
#undef pc_label1
#undef pc_label2
#undef pc_label3
#undef pathcrawler_label
#undef pathcrawler_label1
#undef pathcrawler_label2
#undef __PC__LABEL

#define __PC__VA_NUM_ARGS(...) __PC__VA_NUM_ARGS_IMPL(__VA_ARGS__,9,8,7,6,5,4,3,2,1)
#define __PC__VA_NUM_ARGS_IMPL(_1,_2,_3,_4,_5,_6,_7,_8,_9,N,...) N
#define __PC__VA_NUM_SWITCH(name, n, ...) __PC__VA_NUM_SWITCH_AUX(name, n, __VA_ARGS__)
#define __PC__VA_NUM_SWITCH_AUX(name, n, ...) name ## n (__VA_ARGS__)

#define pc_label(...) __PC__VA_NUM_SWITCH(pc_label, __PC__VA_NUM_ARGS(__VA_ARGS__),__VA_ARGS__)
#define pc_label1(cond) __PC__LABEL(__COUNTER__, cond, "")
#define pc_label2(cond, id) __PC__LABEL(id, cond, "")
#define pc_label3(cond, id, tag) __PC__LABEL(id, cond, tag)

#define pathcrawler_label(...) __PC__VA_NUM_SWITCH(pathcrawler_label, __PC__VA_NUM_ARGS(__VA_ARGS__), __VA_ARGS__)
#define pathcrawler_label1(cond) __PC__LABEL(__COUNTER__, cond, "")
#define pathcrawler_label2(cond,tag) __PC__LABEL(__COUNTER__, cond, tag)

#define __PC__LABEL(id, cond, tag) covlabels_report(id, cond, tag, __FILE__, __LINE__)

/******************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#define COVLABELS_MAX 256

static FILE* covlabels_file = (void*) 0;
static char covlabels_cache[COVLABELS_MAX] = {0};

// will be called at exit
void covlabels_exit() {
  if (covlabels_file) { fclose(covlabels_file); covlabels_file = (void*) 0; }
}

// will be called before main (GCC magic)
__attribute__((constructor))  void covlabels_init () {
//  fprintf(stderr, "[TEST HARNESS] init coverage output (%s for %d labels)\n", xstr(COVLABELS_OUTPUT), COVLABELS_EXPECTED);
  covlabels_file = fopen(xstr(COVLABELS_OUTPUT), "w");
  if (!covlabels_file) {
    fprintf(stderr, "[TEST HARNESS] cannot init coverage output file (%s)", xstr(COVLABELS_OUTPUT));
    return;
  }
  fprintf(covlabels_file, "# %s\n", xstr(COVLABELS_TESTDRIVERS));
  fprintf(covlabels_file, "# id,condition value,file:line,tag\n");
  atexit(covlabels_exit);
//  fprintf(stderr,"[TEST HARNESS] init done\n");
}

void covlabels_report(unsigned int id, int cond, const char* tag, const char* file, unsigned int line) {
  if (!covlabels_file) return;

  cond = !!cond;
  if (id >= COVLABELS_MAX) {
    // no caching
    fprintf(covlabels_file, "%u,%d,%s,%s:%u\n", id, cond, tag, file, line);
    return;
  }

  // Goal: prevent a lot of superfluous coverage line that may occur when
  // label are in loops
  // -> the output file will contains at most COVLABELS_EXPECTED*2 lines

//  fprintf(stderr, "label #%d reached with condition %d\n",id,cond);
  switch(covlabels_cache[id]) {
  case 0: // Label not reached at all
    fprintf(covlabels_file, "%u,%d,%s,%s:%u\n", id, cond, tag, file, line);
    covlabels_cache[id] = 1 + cond;
    break;

  case 1: // Reached negatively
    if (!cond) return; // nothing new here

    // Becomes covered!
    fprintf(covlabels_file, "%u,%d,%s,%s:%u\n", id, 1, tag, file, line);
    covlabels_cache[id] = 3;
    break;

  case 2: // Reached positively (i.e. covered)
    if (cond) return; // nothing new here

    // Becomes reached negatively (are we interested in that?)
    fprintf(covlabels_file, "%u,%d,%s,%s:%u\n", id, 0, tag, file, line);
    covlabels_cache[id] = 3;
    break;

  case 3: // Reached negatively and positively
    return;
  }

  fflush(covlabels_file);
}
